using System;

using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

using DarkStrideToolbox;


namespace DarkStride.StellarLanes.SharedDLL
{
	#region Enumerations
	public enum enumHUDDetail
	{
		None = 0,
		Name = 1,
		HP3ColorIndicator = 2,
		HPBar = 3,
		HPShieldBar = 4,		
		HPShieldEnergy = 5,
		Trajectory = 6
	}
	public enum enumRenderType
	{
		Underside,
		Modules,
		Topside,
		AboveShip,
		HUD
	}

	public enum enumChassisDirection
	{
		Up,
		Right,
		Down,
		Left
	}

	public enum enumModuleType
	{
		CantBeUsed = 1,
		Connector = 256,
		OpenSpace = 512,

		Engine = 2,
		PowerGen = 4,
		ShieldGen = 8,
		Hanger = 16,
		Weapon = 32,
		HUD = 64,
		Other = 128,
		
		All = 254,
		AllButWeapon = 222
	}

	public enum enumMovementType
	{
		Forward,
		Backward,
		TurnLeft,
		TurnRight,
		LastItem
	}

	public enum enumEntProperties
	{
		SpecialTraits_SelfRepair = 0,
		SpecialTraits_PowerTap = 1,
		SpecialTraits_Wpn_RechargeRate_Prcnt = 2,

		Energy_Produced,
		Energy_Available,
		Energy_MaxStorage,
		Energy_CurrentStorage,

		Shield_Current,
		Shield_Max,

		Structure_Max,
		Structure_Current,
		Structure_Mass,
		Structure_PercentDamageRedux,
		Structure_FixedDamageRedux,

		Weapon_SecondsToRecharge,

		Movement_LinearThrust,
		Movement_AngularThrust,
		Movement_EtherialLinearDrag,
		Movement_EtherialAngularDrag,
		Movement_LinearThrust_Max,

		HUD_HPDetail,

		LastItem
	}

	public enum enumEntityType
	{
		Ship,
		Debris,
		Projectile,
		Effect,
		Astrological,
		Loot
	}
	public enum enumItemLevel
	{
		Normal,		//Normal
		Advanced,	//Nightmare
		Expert		//Hell
	}
	public enum enumItemClass
	{
		Routine,		//Normal
		Charged,		//Magic
		SuperCharged,	//Rare
		Legacy			//Unique
	}
	/*public enum enumItemSpecialTrait
	{
		SelfRepair,
		PowerTap,

		//	More effecient
		//		Weapons
					Wpn_RechargeRate_Prcnt,
		//			Extra damage
		//			Shield peircing
		//			Armor peircing
		//			System damaging
		//			Chance of double damage
		//		Sheilds
		//			Shield regen rate
		//			Hard shields
		//		General 
		//			Power use
		//		Engines
		//			Power use
		//			Thrust
		//	Gives hero stats?
		//	Increases armor

		LastItem
	}*/
	public enum enumEditorObject
	{
		Chassis,
		Modules,
		Skins,
		Unassigned
	}
	public enum enumGameScreen
	{
		InSpace,
		Editor,
		CharSheet
	};
	#endregion


	public class Globals
	{
		public struct QuadVertex 
		{
			public float X, Y, Z;	// Position
			public UInt32 color;
			public float Tu1, Tv1;	// Alphamap coordinates
			public float Tu2, Tv2;	// Texture coordinates
		};

		#region Properties

		private static Globals m_oSingletonInstanceOfMe = null;
		private DSGameEngine m_oGameEngine = null;
		private DSNetworkWrapper m_oNetwork = null;
		private Session m_oSession = null;
		private ComplexEntity m_oOurShip = null;
		private Profile m_oProfile = null;
		private bool m_bIAmTheServer = false;
		private DSNetPrimaryKeyGenerator m_oPrimaryKey = null;
		#endregion


		private Globals()
		{
		}

		public static Globals Inst()
		{
			if( m_oSingletonInstanceOfMe == null )
			{
				m_oSingletonInstanceOfMe = new Globals();
			}

			return( m_oSingletonInstanceOfMe );
		}

		public static double ShipAngleToMathAngle( double nShipAngle )
		{
			double nMathAngle = nShipAngle;
			nMathAngle = Math.PI * 2 - nMathAngle;
			nMathAngle += Math.PI / 2.0;
			return( nMathAngle );
		}
		public static double MathAngleToShipAngle( double nMathAngle )
		{
			double nShipAngle = nMathAngle;
			nShipAngle = Math.PI / 2.0 - nShipAngle;
			nShipAngle += Math.PI * 2.0;
			return( nShipAngle );
		}


		public static Chassis AddChassis( ComplexEntity oShip,int nChassisID,int nX,int nY )
		{
			Chassis oNewChassis = null;

			//oNewChassis = (Chassis)Activator.CreateInstance( oType,new object[]{ oShip } );
			oNewChassis = new GenericChassis( oShip,nChassisID );
			oNewChassis.CreatedAsNewItem();
			oNewChassis.XOffset = nX;
			oNewChassis.YOffset = nY;
			oShip.AddChassis( oNewChassis );

			return( oNewChassis);
		}

		public static Module AddModule( ComplexEntity oShip,Chassis oChassis,Type oType,int nX,int nY )
		{
			Module oNewModule = null;

			oNewModule = (Module)Activator.CreateInstance( oType,new object[]{ oShip } );
			oNewModule.CreatedAsNewItem();
			oNewModule.XOffset = nX;
			oNewModule.YOffset = nY;
			oChassis.AddModule( oNewModule );

			return( oNewModule);
		}
		public static Module AddModule( ComplexEntity oShip,Chassis oChassis,int nGenericModuleID,int nX,int nY )
		{
			GenericModule oNewModule = null;

			oNewModule = new GenericModule( oShip,nGenericModuleID );
			oNewModule.CreatedAsNewItem();
			oNewModule.XOffset = nX;
			oNewModule.YOffset = nY;
			oChassis.AddModule( oNewModule );

			return( oNewModule);
		}


		public static bool ObjectIsComplexEntity( object oObjectToCheck )
		{
			Type oTempType = oObjectToCheck.GetType();

			while( oTempType != null )
			{
				if( oTempType == typeof( ComplexEntity ) )
				{
					return( true );
				}
				else
				{
					oTempType = oTempType.BaseType;
				}
			}

			return( false );
		}
		public static bool ObjectIsModule( object oObjToCheck )
		{
			if( oObjToCheck.GetType().BaseType == typeof( Module ) ||
				oObjToCheck.GetType().BaseType.BaseType == typeof( Module ) )
			{
				return( true );
			}
			else
			{
				return( false );
			}
		}
		public static bool ObjectIsChassis( object oObjToCheck )
		{
			if( oObjToCheck.GetType().BaseType == typeof( Chassis ) )
			{
				return( true );
			}
			else
			{
				return( false );
			}
		}

		public static int PlaySound( string sSoundKey,Location oLocation )
		{
            int nRetVal = -1;

            try
            {
                if (Globals.Inst().IAmTheServer == false && 
                    (
                        oLocation == null ||
                        Globals.Inst().OurShip == null || 
                        Globals.Inst().OurShip.Location.ZoneID == oLocation.ZoneID 
                    )
                   )
                {
                    nRetVal = Globals.Inst().GameEngine.DirectSound.PlaySound(sSoundKey);
                }
            }
            catch (System.Exception oEx)
            {
                throw new System.Exception("Failed to play sound", oEx);
            }

            return (nRetVal);
		}


		#region Properties
		public DSGameEngine GameEngine
		{
			get
			{
				return( m_oGameEngine );
			}
			set
			{
				m_oGameEngine = value;
			}
		}
		public Session Session
		{
			get
			{
				return( m_oSession );
			}
			set
			{
				m_oSession = value;
			}
		}
		public ComplexEntity OurShip
		{
			get
			{
				return( m_oOurShip );
			}
			set
			{
				m_oOurShip = value;
			}
		}
		public Profile Profile
		{
			get
			{
				return( m_oProfile );
			}
			set
			{
				m_oProfile = value;
			}
		}
		public DSNetworkWrapper Network
		{
			get
			{
				if( m_oNetwork == null && m_oGameEngine != null )
				{
					return( m_oGameEngine.DirectPlay );
				}
				else
				{
					return( m_oNetwork );
				}
			}
			set
			{
				m_oNetwork = value;
			}
		}
		public bool IAmTheServer
		{
			get
			{
				return( m_bIAmTheServer );
			}
			set
			{
				m_bIAmTheServer = value;
			}
		}
		public DSNetPrimaryKeyGenerator PrimaryKey
		{
			get
			{
				return( m_oPrimaryKey );
			}
			set
			{
				m_oPrimaryKey = value;
			}
		}

        public Zone MyZone
        {
            get
            {
                Zone oMyZone = this.Session.Zones[this.OurShip.Location.ZoneID.ToString()];
                return (oMyZone);
            }
        }
		#endregion
	}
}
    